<?php

namespace App\Models\HR;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sickness extends Model 
{

    protected $table = 'sickness';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function appointment()
    {
        return $this->belongsTo('App\Models\HR\Appointment', 'appointment_id');
    }

    public function approver()
    {
        return $this->belongsTo('App\Models\HR\Appointment', 'approver_id');
    }

}